<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\CatalogGraphQl\Model\Resolver\Product;

use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Catalog\Model\Product;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;

/**
 * Format the new from and to typo of legacy fields news_from_date and news_to_date
 */
class NewFromTo implements ResolverInterface
{
    /**
     * Transfer data from legacy news_from_date and news_to_date to new names corespondent fields
     *
     * {@inheritdoc}
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        if (!isset($value['model'])) {
            throw new GraphQlInputException(__('"model" value should be specified'));
        }

        /** @var Product $product */
        $product = $value['model'];
        $attributeName = substr_replace($field->getName(), 's', 3, 0);

        $data = null;
        if ($product->getData($attributeName)) {
            $data = $product->getData($attributeName);
        }

        return $data;
    }
}
